<?php
if ($argc < 2) {
    print "$argv[0]: funkcja/metoda, klasy1.php [, ... klasyN.php]\n";
    exit;
}

// Pobranie nazwy funkcji
$function = $argv[1];

// Wczenie plikw
foreach (array_slice($argv, 2) as $filename) {
    include_once $filename;
}

try {
    if (strpos($function, '::')) {
        // Metoda
        list ($class, $method) = explode('::', $function);
        $reflect = new ReflectionMethod($function);
    } else {
         // Funkcja
         $reflect = new ReflectionFunction($function);
    }

    $file = $reflect->getFileName();
    $line = $reflect->getStartLine();

    printf ("%s | %s | %d\n", "$function()", $file, $line);
} catch (ReflectionException $e) {
    printf ("Plik %s nie zosta znaleziony.\n", "$function()");
}
?>
